/*
 * Decompiled with CFR 0.152.
 */
package Entity;

import Entity.MenuObject;
import Entity.Mouse;
import Handlers.Options;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class MenuOption
extends MenuObject {
    private String[] strings;
    private String[] oneString = new String[]{""};
    private Color[] color = new Color[9];
    private int spacingx = 0;
    private int spacingy = 0;
    private int currentChoice = 0;
    private int limit = 0;

    public MenuOption(String s, Font font, int x, int y) {
        this.x = x;
        this.y = y;
        this.oneString[0] = s;
        this.strings = this.oneString;
        Canvas c = new Canvas();
        FontMetrics fm = c.getFontMetrics(font);
        this.cwidths[0] = fm.stringWidth(s);
        this.cheights[0] = fm.getHeight();
    }

    public MenuOption(String[] s, Font font, int x, int y, int spacingx, int spacingy) {
        this.x = x;
        this.y = y;
        this.spacingx = spacingx;
        this.spacingy = spacingy;
        this.strings = s;
        Canvas c = new Canvas();
        FontMetrics fm = c.getFontMetrics(font);
        int i = 0;
        while (i < this.strings.length) {
            this.cwidths[i] = fm.stringWidth(this.strings[i]);
            this.cheights[i] = fm.getHeight();
            ++i;
        }
    }

    public MenuOption(String[] s, int limit, Font font, int x, int y, int spacingx, int spacingy) {
        this.x = x;
        this.y = y;
        this.spacingx = spacingx;
        this.spacingy = spacingy;
        this.limit = limit;
        this.strings = s;
        Canvas c = new Canvas();
        FontMetrics fm = c.getFontMetrics(font);
        int i = 0;
        while (i < this.strings.length - limit) {
            this.cwidths[i] = fm.stringWidth(this.strings[i]);
            this.cheights[i] = fm.getHeight();
            ++i;
        }
    }

    public void update(Mouse m) {
        if (Options.getOption(5)) {
            this.currentChoice = -1;
            int i = 0;
            while (i < this.strings.length - this.limit) {
                if (this.intersects(m, i, this.spacingx, this.spacingy)) {
                    this.currentChoice = i;
                    this.color[i] = Color.yellow;
                } else {
                    this.color[i] = Color.white;
                }
                ++i;
            }
        }
    }

    @Override
    public void draw(Graphics2D g) {
        int i = 0;
        while (i < this.strings.length - this.limit) {
            g.setColor(this.color[i]);
            this.drawCenteredString(this.strings[i], (int)(this.x + (double)(i * this.spacingx)) * 2, (int)(this.y + (double)(i * this.spacingy)) * 2, g);
            ++i;
        }
        if (Options.getOption(4)) {
            g.setColor(Color.MAGENTA);
            i = 0;
            while (i < this.strings.length) {
                g.drawRect((int)this.x - this.cwidths[i] / 2 + i * this.spacingx, (int)this.y - this.cheights[i] / 2 + i * this.spacingy, this.cwidths[i], this.cheights[i]);
                ++i;
            }
        }
    }

    public void drawCenteredString(String s, int w, int h, Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int x = (w - fm.stringWidth(s)) / 2;
        int y = fm.getAscent() + (h - (fm.getAscent() + fm.getDescent())) / 2;
        g.drawString(s, x, y);
    }

    public int getChoice() {
        return this.currentChoice;
    }
}

